<x-app-layout>
    <x-slot name="header">
        Reviews
    </x-slot>

    <div class="container mt-4">
        <div class="row">
            @foreach ($reviews as $review)
                <div class="col-md-6 mb-4">
                    <div class="card shadow-sm text-primary bg-primary-transparent card-transparent">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h5 class="card-title mb-0">{{$review->reviewable->name}}</h5>
                                <span class="text-muted small">{{$review->created_at->format('M d, Y')}}</span>
                            </div>
                            <div class="mb-3">
                                @for ($i = 0; $i < 5; $i++)
                                    @if ($i < $review->rating)
                                        <i class="fe fe-star text-warning"></i>
                                    @else
                                        <i class="fe fe-star text-muted"></i>
                                    @endif
                                @endfor
                            </div>
                            <p class="card-text">{!! $review->content !!}</p>
                            <div class="d-flex justify-content-end gap-2">
                                <a href="{{ route('user.review.edit', $review->id) }}" class="btn btn-sm btn-outline-primary">
                                    <i class="fe fe-edit"></i> Edit
                                </a>
                                <form action="{{ route('user.review.destroy', $review->id) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-outline-danger confirm-delete">
                                        <i class="fe fe-trash"></i> Delete
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
    <x-slot name="script">
        <x-confirm-js />
    </x-slot>
</x-app-layout>
